/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef NP_RAGDOLL_CONTROLLER_DEMO_H
#define NP_RAGDOLL_CONTROLLER_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>

class NpRagdollControllerDemo : public hkDefaultPhysicsDemo
{
public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	NpRagdollControllerDemo(hkDemoEnvironment* env);
	~NpRagdollControllerDemo();

	hkDemo::Result stepDemo();

private:
	void createRagdollInstance();
	void applyBallGun();
	void applyRaycastGun();
	void doSkinning(const class hkaPose& pose, const hkTransform& tr = hkTransform::getIdentity());
	void handleTweakingInput();
	void showHelp();
	void drawResultPoses(hkaPose& ragdollPose, hkaPose& animPose);
	void onRigidBodyContollerMode(hkaPose& ragdollPose, hkLocalArray<hkColor::Argb>& rbColors);
	void onPoweredContollerMode(hkaPose& ragdollPose);
	void onKeyframeMode(hkaPose& ragdollPose);
	void onModeChanged(hkInt32 oldMode, hkInt32 newMode);

private:
	class AnimationControlListener;
	struct Extension;

	class hkLoader* m_loader;

	class hkaSkeletonMapper* m_highToLowMapper; 
	class hkaSkeletonMapper* m_lowToHighMapper;

	class hkaAnimatedSkeleton* m_animatedSkeleton;
	AnimationControlListener*  m_animationControlListener;

	class hknpRagdollData* m_ragdollData;
	class hknpRagdoll* m_ragdoll;
	class hknpRagdollKeyFrameHierarchyController* m_keyframeHierarchyController;
	class hknpRagdollMotorController* m_motorController;
	class hkpPositionConstraintMotor* m_posConstraintMotor;
	class hkpVelocityConstraintMotor* m_velConstraintMotor;
	class hkaSkeleton* m_ragdollSkeleton;

	hkArray< hkRefPtr<class hkaMeshBinding> > m_skinBindings;
	hkArray< hkRefPtr<class hkaBoneAttachment> > m_boneAttachments;
	hkArray< class hkgDisplayObject* > m_boneAttachmentObjects;
	
	bool m_playing;

	class hknpBallGun* m_ballGun;

	Extension* m_extension;
};

#endif // NP_RAGDOLL_CONTROLLER_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
