/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Animation/Api/Ragdoll/RagdollAnimation/NpRagdollAnimationDemo.h>

#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>
#include <Demos/DemoCommon/Utilities/Animation/AnimationUtils.h>

#include <Common/Serialize/Util/hkLoader.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Physics/Physics/Collide/Shape/Convex/hknpConvexShape.h>
#include <Physics/Physics/Collide/Filter/Constraint/hknpConstraintCollisionFilter.h>
#include <Physics/Physics/Extensions/PhysicsSystem/hknpPhysicsSystem.h>

#include <Animation/Animation/Rig/hkaPose.h>
#include <Animation/Animation/hkaAnimationContainer.h>
#include <Animation/Animation/Playback/hkaAnimatedSkeleton.h>
#include <Animation/Animation/Playback/Control/Default/hkaDefaultAnimationControl.h>
#include <Animation/Animation/Mapper/hkaSkeletonMapperUtils.h>

#include <Animation/PhysicsBridge/Ragdoll/hknpRagdoll.h>
#include <Animation/PhysicsBridge/RagdollUtils/hknpRagdollUtils.h>
#include <Animation/PhysicsBridge/Ragdoll/Controller/Body/hknpRagdollBodyController.h>

// For HKA_DEMO defines
#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

static const char* ASSET_RAGDOLL = "Resources/Animation/NpRagdoll/zombie_dismemberment_ragdoll.hkt";
static const char* ASSET_ANIMATION = "Resources/Animation/Ragdoll/zombie_dismemberment_agrowalk.hkt";

NpRagdollAnimationDemo::NpRagdollAnimationDemo(hkDemoEnvironment* env)
	: hkDefaultPhysicsDemo(env)
	, m_animationSkeleton( HK_NULL )
	, m_animationPlayer( HK_NULL )
	, m_skeletonMapper( HK_NULL )
	, m_ragdoll( HK_NULL )
	, m_ragdollController( HK_NULL )
	, m_animate( true )
{
	// Set up the camera
	{
		hkVector4 from(5.0f, -5.0f, 1.0f);
		hkVector4 to  (0.0f, 0.0f,  1.0f);
		hkVector4 up  (0.0f, 0.0f,  1.0f);
		setupDefaultCameras( env, from, to, up );
	}

	// Create the world
	hknpConstraintCollisionFilter* filter = new hknpConstraintCollisionFilter( HK_NULL );
	{
		hknpWorldCinfo info;
		info.m_persistentStreamAllocator = getPersistentAllocator();
		info.setBroadPhaseSize( 200.0f );
		info.m_gravity.set( 0.0f, 0.0f, -9.81f );
		info.m_collisionFilter.setAndDontIncrementRefCount( filter );

		m_npWorld.setAndDontIncrementRefCount(new hknpWorld(info));

		setupGraphics();
	}

	// Create a floor
	{
		hknpBodyCinfo info;
		{
			info.m_shape = hknpConvexShape::createFromHalfExtents( hkVector4( 10.0f, 10.0f, 1.0f ) );
			info.m_position.set( 0, 0, -1.5f );
		}

		m_npWorld->createStaticBody( info );
		info.m_shape->removeReference();
	}

	// Load the (old) ragdoll
	{
		m_loader = new hkLoader();

		hkStringBuf assetFile(ASSET_RAGDOLL); hkAssetManagementUtil::getFilePath(assetFile);
		hkRootLevelContainer* dataContainerRig = m_loader->load( HK_GET_DEMOS_ASSET_FILENAME(assetFile.cString()) );
		HK_ASSERT2(0x27343437, dataContainerRig != HK_NULL , "Could not load data asset");
		
		// Grab the ragdoll data and optimize it
		hknpRagdollData* ragdollData = reinterpret_cast<hknpRagdollData*>( dataContainerRig->findObjectByType( hknpRagdollDataClass.getName() ));
		HK_ASSERT2(0, ragdollData, "Couldn't load ragdoll setup");
		hknpRagdollUtils::optimizeInertias( ragdollData );

		// Create our instance
		m_ragdoll = new hknpRagdoll( ragdollData, m_npWorld, hkTransform::getIdentity() );

		// Iterate over all hkaSkeletonMapper objects and look for an animation skeleton and skeleton mappers
		const hkaSkeleton* tempLowSkeleton = ragdollData->m_skeleton;
		void* objectFound = dataContainerRig->findObjectByType( hkaSkeletonMapperClass.getName() );
		while ( objectFound )
		{
			hkaSkeletonMapper* mapper = reinterpret_cast<hkaSkeletonMapper*>( objectFound );

			// Use the skeleton to determine which mapper is which
			if ( mapper->m_mapping.m_skeletonA == tempLowSkeleton )
			{
				m_animationSkeleton = const_cast<hkaSkeleton*>(mapper->m_mapping.m_skeletonB.val());
			}
			if ( mapper->m_mapping.m_skeletonB == tempLowSkeleton )
			{
				m_skeletonMapper = mapper;
				m_animationSkeleton = const_cast<hkaSkeleton*>(mapper->m_mapping.m_skeletonA.val());
			}

			// Find the next object of this type
			objectFound = dataContainerRig->findObjectByType( hkaSkeletonMapperClass.getName(), objectFound );
		}
		HK_ASSERT2(0x22440119, m_skeletonMapper, "Couldn't load mapping");
		HK_ASSERT2(0x22440120, m_animationSkeleton, "Couldn't load high-to-ragdoll mapping");
	}

	// Get the animations and the bindings
	{
		hkStringBuf assetFile(ASSET_ANIMATION); hkAssetManagementUtil::getFilePath(assetFile);
		hkRootLevelContainer* container = m_loader->load( HK_GET_DEMOS_ASSET_FILENAME(assetFile.cString()) );
		HK_ASSERT2(0x27343437, container != HK_NULL , "Could not load asset");
		hkaAnimationContainer* animContainer = reinterpret_cast<hkaAnimationContainer*>( container->findObjectByType( hkaAnimationContainerClass.getName() ));

		HK_ASSERT2(0x27343435, animContainer && (animContainer->m_bindings.getSize() > 0), "No binding loaded");
		hkaAnimationBinding* binding = animContainer->m_bindings[0];

		// create a player and add the loaded animation to it, so that we can play it later
		m_animationPlayer = new hkaAnimatedSkeleton( m_animationSkeleton );
		hkaDefaultAnimationControl* animControl = new hkaDefaultAnimationControl( binding );
		m_animationPlayer->addAnimationControl( animControl ); animControl->removeReference();
	}

	// Create a new ragdoll from the old one
	{
		// Create controller
		m_ragdollController = new hknpRagdollBodyController( m_ragdoll, m_npWorld );

		// the ragdoll doesn't move every step, and the delta time never changes, so we can just do this once.
		m_ragdollController->update( hkQsTransform::getIdentity(), m_timestep );

		m_ragdollController->setStrength( 0.5f );
	}

	filter->updateFromWorld( m_npWorld );
}

NpRagdollAnimationDemo::~NpRagdollAnimationDemo()
{
	m_animationPlayer->removeReference();
	m_ragdollController->removeReference();
	m_ragdoll->removeReference();
	delete m_loader;
	m_loader = NULL;
}

hkDemo::Result NpRagdollAnimationDemo::stepDemo()
{
	// handle input
	if ( m_env->m_window->getKeyboard().wasKeyPressed( '1' ) )
	{
		m_ragdollController->setStrength( m_ragdollController->getStrength() - 0.1f );
	}
	if ( m_env->m_window->getKeyboard().wasKeyPressed( '2' ) )
	{
		m_ragdollController->setStrength( m_ragdollController->getStrength() + 0.1f );
	}
	if ( m_env->m_window->getKeyboard().wasKeyPressed( '3' ) )
	{
		m_animate = !m_animate;
	}

	if ( m_animate )
	{
		// Sample animation pose
		hkaPose animationPose( m_animationSkeleton );
		m_animationPlayer->sampleAndCombineAnimations( animationPose.accessUnsyncedPoseLocalSpace().begin(), animationPose.getFloatSlotValues().begin() );
		m_animationPlayer->stepDeltaTime( m_timestep );

		// Map to (old) ragdoll pose
		hkaPose ragdollPose( m_skeletonMapper->m_mapping.m_skeletonB );
		ragdollPose.setToReferencePose();
		m_skeletonMapper->mapPose( animationPose, ragdollPose, hkaSkeletonMapper::CURRENT_POSE );

		// Set desired (new) ragdoll pose
		m_ragdollController->setDesiredPose( ragdollPose.getSyncedPoseLocalSpace().begin() );
		m_ragdollController->driveToPose();
	}

	return hkDefaultPhysicsDemo::stepDemo();
}


#if defined(HK_COMPILER_MWERKS)
#	pragma force_active on
#	pragma fullpath_file on
#endif

static const char helpString[] = "Basic ragdoll animation demo.\n1/2 - decrease/increase controller strength\n3 - toggle animation";

HKA_DECLARE_PHYSICS_DEMO( NpRagdollAnimationDemo, HK_DEMO_TYPE_PHYSICS, "Ragdoll animation", helpString );

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
