/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HKNP_RAGDOLL_PENETRATION_DETECTION_DEMO_H
#define HKNP_RAGDOLL_PENETRATION_DETECTION_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>

#include <Animation/PhysicsBridge/Penetration/hkaNpRagdollPenetrationDetector.h>


#define NUM_POSES 6

class NpRagdollPenetrationDetectionDemo : public hkDefaultPhysicsDemo 
{
	public:

		// Collision Layers used in this demo.
		// By enabling and disabling collisions between these layers, we can tweak the behaviour of the demo
		enum
		{
			LAYER_LANDSCAPE = 1,
			LAYER_RAGDOLL_DYNAMIC = 2,
			LAYER_RAGDOLL_KEYFRAMED = 3,
			LAYER_RAGDOLL_PENETRATING = 4,
			LAYER_RAYCAST = 5
		};

	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		NpRagdollPenetrationDetectionDemo( hkDemoEnvironment* env );
		~NpRagdollPenetrationDetectionDemo();

		void stopRagdollFeedback(); // dynamic state
		void doRagdollFeedback();   // keyframed state

		void displayDetectionPose();
		//static void displayRootCdBody( hknpWorld* world, const hkpCollidable* collidable, hkpShapeKey key);

		hkDemo::Result stepDemo();

	private:

		// Changes the body corresponding to the bone to keyframed to drive the ragdoll
		void setBodyKeyframed( int boneId );

		// Set the body corresponding to the bone to dynamic, without applying correction
		void setBodyDynamic(int boneId );

		// Set the body corresponding to the bone to dynamic, disable collision with the landscape and if requested
		// apply correction
		void setBodyDynamicWithCorrection( hknpBodyId rb, int boneId, int parentId, bool applyForce );

	private:

		// Static landscape
		class hknpPhysicsSystem* m_landscape;

		// The ragdoll data and its instance in the wold
		class hknpRagdollData* m_ragdollData;
		class hknpRagdoll* m_ragdollInstance;

		// Time of the simulaiton
		hkReal m_time;

		// Ragdoll states (keyframed = false or ragdoll = true)
		hkBool m_statusFlag;

		// Current pose
		int m_poseId;

		// With or without correction flag
		hkBool m_correctionFlag;

		// Array of available poses
		class hkaPose* m_posesLowRes[NUM_POSES];

		// Detect penetration classes
		// Interface for world raycasting
		class hkaNpRagdollRaycastInterface* m_ragdollRaycastInterface;

		// Main penetration detection class
		class hkaNpRagdollPenetrationDetector* m_detectRagdollPenetration;

		// Result of penetration detection.
		hkaNpRagdollPenetrationDetector::Output m_penetratedBones;

		// current velocity and turn
		hkReal m_turn;
		hkVector4 m_pos;

		// The current reference frame transformation (world-from-model)
		hkQsTransform m_currentTransform;
		hkArray<hkReal> m_masses;

		// Asset file loader.
		class hkLoader* m_loader;
};

#endif  // HKNP_RAGDOLL_PENETRATION_DETECTION_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
