/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_NP_CONSTRAINT_MATCHING_DEMO_H
#define HK_NP_CONSTRAINT_MATCHING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysicsDemo.h>

class NpConstraintMatchingDemo : public hkDefaultPhysicsDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		NpConstraintMatchingDemo(hkDemoEnvironment* env);

		~NpConstraintMatchingDemo();

		hkDemo::Result stepDemo();

	protected:

		class hkLoader* m_loader;

		class hkaSkeletonMapper* m_highToLowMapper;

		class hkaSkeleton* m_highSkeleton;

		class hkaAnimatedSkeleton* m_animatedSkeleton;
		class hkaAnimation* m_animation;
		class hkaAnimationBinding* m_binding;

		class hknpRagdoll* m_ragdoll;
		class hknpRagdollKeyFrameHierarchyController* m_keyFrameController;

	private:
		void setupRagdoll();

public:
	void showConstraintStress();
	hkReal checkLimitedHingeConstraint(const class hknpConstraint* constraint, int i);
	hkReal checkRagdollConstraint(const class hknpConstraint* constraint, int i);
	void colorConstraintByStress(const class hknpConstraint* constraint, hkReal stress);

};

#endif // HK_NP_CONSTRAINT_MATCHING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
