/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_CONSTRAINT_MATCHING_DEMO_H
#define HK_CONSTRAINT_MATCHING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

class ConstraintMatchingDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		ConstraintMatchingDemo(hkDemoEnvironment* env);

		~ConstraintMatchingDemo();

		hkDemo::Result stepDemo();

	protected:

		class hkLoader* m_loader;

		class hkaSkeletonMapper* m_highToLowMapper;
		class hkaSkeletonMapper* m_lowToHighMapper;

		class hkaSkeleton* m_highSkeleton;

		class hkaAnimatedSkeleton* m_animatedSkeleton;
		class hkaAnimation* m_animation;
		class hkaAnimationBinding* m_binding;

		class hkaRagdollInstance* m_ragdollInstance;
		class hkaRagdollRigidBodyController* m_rigidBodyController;

	private:
		void setupRagdoll();

public:
	void showConstraintStress();
	hkReal checkLimitedHingeConstraint(class hkpConstraintInstance* constraint, int i);
	hkReal checkRagdollConstraint(class hkpConstraintInstance* constraint, int i);
	hkColor::Argb colorConstraintByStress(hkpConstraintInstance* constraint, hkReal stress);

};

#endif // HK_CONSTRAINT_MATCHING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
