/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef SKELETON_MAPPING_ANIMATION_MULTITHREADING_DEMO_H
#define SKELETON_MAPPING_ANIMATION_MULTITHREADING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>
#include <Common/Base/Thread/Semaphore/hkSemaphoreBusyWait.h>

// This demo shows how to use the Animation Jobs (hkaAnimationSampleAndCombineJob) to sample and
// blend an animated skeleton. 
// The demo does not use an animation cache by default (though it can be turned on).
//
// At runtime, the optimal sampling strategy is chosen depending on where the job is being run (i.e. depending 
// on the architecture on which the code is being run):
//  If the (multithreaded) job processing takes place on PPU/CPU then the m_animatedSkeletonOnCPU memeber
// of the data is accessed directly and sampling and blending takes place through the hkaCpuSampleAndCombineJob()
// method which calls sampleCombineJob.m_animatedSkeletonOnCPU->sampleAndCombinePartialAnimations() directly.
//  Otherwise, the (multithreaded) job processing takes place on SPU then the hkaSpuSampleAndCombineJob() method 
// is called, the animation data (chunks) is DMAd over, and the samplePartialWithDataChunks() method is used.
class SkeletonMappingMultithreadingDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		SkeletonMappingMultithreadingDemo( hkDemoEnvironment* env );

		~SkeletonMappingMultithreadingDemo();

		void doSamplingMultithreaded();
		void doMappingMultithreaded();

		Result stepDemo();

	private:

		class hkLoader* m_loader;

		class hkaSkeletonMapper* m_highToLowMapper;
		class hkaSkeletonMapper* m_lowToHighMapper;

		class hkaSkeleton* m_highSkeleton;
		class hkaSkeleton* m_lowSkeleton;

		hkArray< class hkaAnimatedSkeleton* > m_highAnimatedSkeletons;
		class hkaAnimation* m_highAnimation;
		class hkaAnimationBinding* m_highBinding;

		hkArray< class hkaPose* > m_highPoses;
		hkArray< class hkaPose* > m_lowPoses;

		hkBool m_useMt;
};

#endif //SKELETON_MAPPING_ANIMATION_MULTITHREADING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
