/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef MIRRORED_MOTION_DEMO_H
#define MIRRORED_MOTION_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>

// Vertex Deformation
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>

// Attachments
#include <Animation/Animation/Rig/hkaBoneAttachment.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimation;
class hkaAnimationBinding;
class hkaAnimatedSkeleton;
class hkaDefaultAnimationControl;

	// Demonstrate runtime mirroring of animations using the hkMirroredSkeletalAnimation class
class MirroredMotionDemo : public hkDefaultAnimationDemo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		MirroredMotionDemo( hkDemoEnvironment* env );

		~MirroredMotionDemo();

		Result stepDemo(); 

		void makeFakeInput();

	private:

		hkLoader* m_loader;

		hkaSkeleton* m_skeleton;

		// [0] is loaded from a file, [1] is mirrored
		hkaAnimation* m_animation[2];
		hkaAnimationBinding* m_binding[2];
		hkaDefaultAnimationControl* m_control[2];
		hkaAnimatedSkeleton* m_skeletonInstance[2];

		// These are loaded from a file
		hkArray< hkRefPtr<hkaMeshBinding> > m_skinBindings[2];
		hkArray< hkRefPtr<hkaBoneAttachment> > m_attachments[2];

		int m_axisCounter;
		hkDemoEnvironment *m_env;

		// An array of the graphics meshes that are attached to the skeleton
		hkArray<class hkgDisplayObject*> m_attachmentObjects[2];

		hkBool m_wireframe;
		hkBool m_drawSkin;
		hkBool m_paused;

		hkQsTransform m_accumulatedMotion[2];
		hkBool m_useExtractedMotion;
		hkReal m_separation;
};


#endif // MIRRORED_MOTION_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
