/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef RETARGETING_PARTITION_CHAINS_MT_DEMO_H
#define RETARGETING_PARTITION_CHAINS_MT_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultAnimationDemo.h>
#include <Common/Base/Thread/Semaphore/hkSemaphoreBusyWait.h>

class hkaSkeleton;
class hkaAnimationBinding;

// This demo shows how to use the Animation Jobs to retarget animations that both have chains and partitions. 
//
// The retargeting can be done in two modes (either mapping to the full pose while retargeting or returning a dense 
// partial pose). The advantage to returning a dense partial pose is that this can be blended in partial animation
// space before it is mapped to the full pose at the end.
class RetargetingPartitionsWithChainsMTDemo : public hkDefaultAnimationDemo
{
public:

	HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

	RetargetingPartitionsWithChainsMTDemo( hkDemoEnvironment* env );

	~RetargetingPartitionsWithChainsMTDemo();

	void doSamplingMultithreaded();
	void doMappingMultithreaded();

	void doSamplingAndMappingDenseMultithreaded();

	Result stepDemo();

private:

	class hkLoader* m_loader;

	class hkaSkeletonMapper* m_skelAToSkelBMapper;

	class hkaSkeleton* m_skeletonA;
	class hkaSkeleton* m_skeletonB;

	hkArray< class hkaAnimatedSkeleton* > m_animatedSkeletonsForSkelA;
	class hkaAnimation* m_animationForSkelA;
	class hkaAnimationBinding* m_bindingForSkelA;

	hkArray< class hkaPose* > m_skelAPoses;
	hkArray< class hkaPose* > m_skelBPoses;

	hkArray<hkInt16> m_mappedBPartitionIndices;

	hkBool m_useMt;
};

#endif //RETARGETING_PARTITION_CHAINS_MT_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
