/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Animation/Api/InverseKinematics/FootIkDemoBase.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>

#if defined(HK_FEATURE_PRODUCT_PHYSICS)
#include <Physics/Physics/Collide/Shape/Composite/Mesh/Compressed/hknpCompressedMeshShape.h>
#include <Physics/Physics/Collide/Shape/hknpShapeQueryInterface.h>
#include <Physics/Physics/Collide/Query/Collector/hknpClosestHitCollector.h>
#endif

#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
#include <Physics2012/Collide/Shape/Compound/Collection/SimpleMesh/hkpSimpleMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppUtility.h>
#include <Physics2012/Collide/Shape/Query/hkpShapeRayCastInput.h>
#include <Physics2012/Collide/Shape/Query/hkpShapeRayCastOutput.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppBvTreeShape.h>
#endif

FootIkDemoBase::FootIkDemoBase( hkDemoEnvironment* env )
	:	hkDefaultAnimationDemo(env), m_landscapeShape(HK_NULL)
{}

FootIkDemoBase::~FootIkDemoBase()
{
	m_landscapeShape->removeReference();
}

hkBool FootIkDemoBase::castRay( const hkVector4& fromPointWS, const hkVector4& toPointWS, hkReal& hitFractionOut, hkVector4& normalWSOut )
{
	if ( m_env->m_demoTypeFlags & HK_DEMO_TYPE_USES_PHYSICS )
	{
#if defined(HK_FEATURE_PRODUCT_PHYSICS)
		hknpRayCastQuery query;
		query.m_ray.setEndPoints(fromPointWS, toPointWS);

		hknpClosestHitCollector collector;
		hknpShapeQueryInterface::castRay( query, static_cast<hknpShape&>(*m_landscapeShape), hkTransform::getIdentity(), &collector );

		// check if we've hit anything
		if( collector.hasHit() )
		{
			const hknpRayCastQueryResult& raycastOut = collector.getHits()->asRayCast();
			hitFractionOut = raycastOut.getFraction( query );
			normalWSOut = raycastOut.getSurfaceNormal();
			return true;
		}
		else
		{
			// did not hit anything
			return false;
		}
#endif
	}
	else if ( m_env->m_demoTypeFlags & HK_DEMO_TYPE_USES_PHYSICS_2012 )
	{
#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
		// raycast info structures
		hkpShapeRayCastInput raycastIn;
		hkpShapeRayCastOutput raycastOut;

		raycastIn.m_from = fromPointWS;
		raycastIn.m_to = toPointWS;

		// cast the ray into the landscape
		static_cast<hkpMoppBvTreeShape*>(m_landscapeShape)->castRay( raycastIn, raycastOut );

		// check if we've hit anything
		if( raycastOut.hasHit() )
		{
			hitFractionOut = raycastOut.m_hitFraction;
			normalWSOut = raycastOut.m_normal;
			return true;
		}
		else
		{
			// did not hit anything
			return false;
		}
#endif
	}

	return false;
}

void FootIkDemoBase::createLandscapeShape( hkGeometry* geometry )
{
	if ( m_env->m_demoTypeFlags & HK_DEMO_TYPE_USES_PHYSICS )
	{
#if defined(HK_FEATURE_PRODUCT_PHYSICS)
		hknpDefaultCompressedMeshShapeCinfo meshInfo(geometry);
		m_landscapeShape = new hknpCompressedMeshShape(meshInfo);
#endif
	}
	else if ( m_env->m_demoTypeFlags & HK_DEMO_TYPE_USES_PHYSICS_2012 )
	{
#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
		// Create a mesh shape so that we can use the raycast functionality
		hkpSimpleMeshShape* storageMeshShape = new hkpSimpleMeshShape( 0.01f );
		{
			// setup the storage mesh
			storageMeshShape->m_vertices = geometry->m_vertices;
			storageMeshShape->m_triangles.setSize( geometry->m_triangles.getSize() );

			for( int ti = 0; ti < geometry->m_triangles.getSize(); ti++ )
			{
				storageMeshShape->m_triangles[ti].m_a = geometry->m_triangles[ti].m_a;
				storageMeshShape->m_triangles[ti].m_b = geometry->m_triangles[ti].m_b;
				storageMeshShape->m_triangles[ti].m_c = geometry->m_triangles[ti].m_c;
			}
		}

		// setup mesh and raycasting
		{
			hkpMoppCode* moppCode = hkpMoppUtility::buildCode(storageMeshShape, hkpMoppCompilerInput());

			m_landscapeShape = new hkpMoppBvTreeShape(storageMeshShape, moppCode);
			storageMeshShape->removeReference();
			moppCode->removeReference();
		}
#endif
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
