/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef FOOT_IK_DEMO_H
#define FOOT_IK_DEMO_H

#include <Demos/Animation/Api/InverseKinematics/FootIkDemoBase.h>
#include <Demos/DemoCommon/Utilities/Animation/AnimationUtils.h>

#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>

class hkLoader;
class hkaSkeleton;
class hkaAnimation;
class hkaAnimatedSkeleton;
class hkaAnimationBinding;
class hkaDefaultAnimationControl;
class hkDisplayConvex;
class hkDisplayGeometry;
class hkaPose;
class hkaFootPlacementIkSolver;

class FootIkDemo : public FootIkDemoBase
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		FootIkDemo( hkDemoEnvironment* env );

		~FootIkDemo();

		Result stepDemo();

	protected:

		// bones indices
		enum WhichLeg
		{
			LEFT_LEG,
			RIGHT_LEG,
			MAX_LEGS
		};

		// creates the triangulated landscape
		void buildLandscape( int side );

	private:
		enum
		{
			NUM_ANIMS = 2
		};
		hkLoader* m_loader;

		hkaSkeleton* m_skeleton;

		hkaAnimation* m_animation[ NUM_ANIMS ];

		hkArray< hkRefPtr<hkaMeshBinding> > m_skinBindings;

		hkaAnimatedSkeleton* m_skeletonInstance;

		hkaAnimationBinding* m_binding[ NUM_ANIMS ];

		hkaDefaultAnimationControl* m_control[ NUM_ANIMS ];

		// Display geometry for the landscape
		hkGeometry* m_geometry;

		// allows the geometry to be handled by the display manager
		hkDisplayConvex* m_displayConvex;
		hkArray<hkDisplayGeometry*> m_geometryArray;

		// controls the character movement
		hkQsTransform m_currentMotion;

		// foot placement info
		hkaFootPlacementIkSolver* m_footPlacementComponent [MAX_LEGS];
		hkBool m_ikOn;
};

#endif // FOOT_IK_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
